/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class ColorGenerator {
    private static List<int[]> colorCache = new ArrayList<int[]>();
    public static final int PALETTE_ECLIPSE = 0;
    public static final int PALETTE_PASTEL = 8;
    public static final int PALETTE_RICH = 16;
    public static final int PALETTE_OFFICE = 24;

    public static int[] create(int pos) {
        int[] color = null;
        if (colorCache.size() > pos) {
            return colorCache.get(pos);
        }
        Random rand = new Random();
        int brightness = 40;
        color = new int[]{255 - brightness - rand.nextInt(30), 255 - brightness - rand.nextInt(30), 255 - brightness - rand.nextInt(30)};
        color[pos % 3] = 255;
        try {
            colorCache.add(pos, color);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return color;
    }

    public static final void main(String[] args) throws Exception {
        for (int i = 100; i < 1000; ++i) {
            int[] values = ColorGenerator.create(i);
            System.out.println(i + ": " + Arrays.toString(values));
        }
    }

    static {
        colorCache.add(new int[]{225, 225, 255});
        colorCache.add(new int[]{223, 197, 41});
        colorCache.add(new int[]{249, 225, 191});
        colorCache.add(new int[]{255, 205, 225});
        colorCache.add(new int[]{225, 255, 225});
        colorCache.add(new int[]{255, 191, 255});
        colorCache.add(new int[]{185, 185, 221});
        colorCache.add(new int[]{40, 255, 148});
        colorCache.add(new int[]{255, 161, 161});
        colorCache.add(new int[]{255, 215, 161});
        colorCache.add(new int[]{250, 255, 161});
        colorCache.add(new int[]{197, 255, 161});
        colorCache.add(new int[]{161, 255, 253});
        colorCache.add(new int[]{161, 192, 255});
        colorCache.add(new int[]{161, 255, 213});
        colorCache.add(new int[]{243, 161, 255});
        colorCache.add(new int[]{238, 85, 27});
        colorCache.add(new int[]{81, 180, 51});
        colorCache.add(new int[]{5, 141, 199});
        colorCache.add(new int[]{25, 76, 126});
        colorCache.add(new int[]{255, 127, 15});
        colorCache.add(new int[]{153, 107, 19});
        colorCache.add(new int[]{153, 41, 95});
        colorCache.add(new int[]{226, 226, 54});
        colorCache.add(new int[]{0, 87, 150});
        colorCache.add(new int[]{255, 83, 23});
        colorCache.add(new int[]{255, 218, 46});
        colorCache.add(new int[]{105, 171, 41});
        colorCache.add(new int[]{142, 0, 47});
        colorCache.add(new int[]{147, 210, 255});
        colorCache.add(new int[]{65, 81, 8});
        colorCache.add(new int[]{186, 215, 0});
        colorCache.add(new int[]{93, 45, 128});
        colorCache.add(new int[]{255, 164, 23});
        colorCache.add(new int[]{206, 0, 19});
        colorCache.add(new int[]{0, 148, 216});
    }
}

